import AuthenticatedLayout from "@/Layouts/AuthenticatedLayout";
import { Head, Link } from "@inertiajs/react";

export default function Index({ tenants }) {
    console.log(tenants);
    return (
        <AuthenticatedLayout
            header={
                <h2 className="text-xl font-semibold leading-tight text-gray-800">
                    Tenants List
                </h2>
            }
        >
            <Head title="Dashboard" />

            <div className="py-12">
                <div className="mx-auto max-w-7xl sm:px-6 lg:px-8">
                    <div className="overflow-hidden bg-white shadow-sm sm:rounded-lg">
                        <div className="p-6 text-gray-900">
                            Tota tenants exist {tenants.data.length}
                        </div>
                        {/* PAGINATION LINKS */}
                        <div>
                            {tenants?.links?.map((link) =>
                                link.url ? (
                                    <Link
                                        key={link.label}
                                        href={link.url ? link.url : ""}
                                        className={`p-1 mx-1 ${
                                            link.active
                                                ? "text-blue-500 font-bold"
                                                : ""
                                        }`}
                                    >
                                        {link.label}
                                    </Link>
                                ) : (
                                    <span
                                        key={link.label}
                                        className="p-1 mx-1 text-slate-300"
                                    >
                                        {link.label}
                                    </span>
                                )
                            )}
                        </div>
                    </div>
                </div>
            </div>
        </AuthenticatedLayout>
    );
}
