<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Artisan;

class ProcessUserMigrations extends Command
{
    /**
     * The name and signature of the console command.
     */
    protected $signature = 'process:migrations';

    /**
     * The console command description.
     */
    protected $description = 'Runs the drive:migrate-tenant command for a predefined list of user pairs.';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info("--- Starting the batch migration process. ---");
        logger()->info("--- Starting the batch migration process. ---");

        //
        // DEFINE YOUR LIST OF USERS HERE
        //
         $userPairs = [
  
          
            [
                'source' => 'gsoffice@old.the-aff.org',
                'target' => 'gsoffice@the-aff.org',
                'admin'  => 'it@old.the-aff.org'
            ],
     
       

            // ... add as many user pairs as you need
        ];

        // Loop through each pair and call the migration command
        foreach ($userPairs as $pair) {
            $this->line("=====================================================================");
            $this->info("Dispatching migration for: {$pair['source']} -> {$pair['target']}");
            $this->line("=====================================================================");
            logger()->info("Dispatching migration for: {$pair['source']} -> {$pair['target']}");
            
            try {
                // This is the core logic for calling the other command
                Artisan::call('drive:migrate-tenant ' . $pair['source'] .' '. $pair['target']);

                // You can also get the output from the command if you need it
                $output = Artisan::output();
                $this->line($output);

                $this->info("Successfully dispatched job for {$pair['source']}.");
                logger()->info("Successfully dispatched job for {$pair['source']}.");

            } catch (\Exception $e) {
                $this->error("An error occurred while processing {$pair['source']}: " . $e->getMessage());
                logger()->info("An error occurred while processing {$pair['source']}: " . $e->getMessage());
                // Decide if you want to stop or continue on error
                // continue; 
            }
        }

        $this->info("--- All migration jobs have been dispatched. ---");
        logger()->info("--- All migration jobs have been dispatched. ---");
        return 0;
    }
}
